/* global Twitch */
import Component from 'ember-component';

const LanguageSelectComponent = Component.extend({
  language: null,

  actions: {
    selectLanguage() {
      let code = this.get('language.code');
      Twitch.language.setByAsyncPut(code);
      Twitch.language.setCookieAndReload(code);
    }
  }
});

LanguageSelectComponent.reopenClass({
  positionalParams: ['language']
});

export default LanguageSelectComponent;
