import Component from 'ember-component';
import Ember from 'ember';

const {run} = Ember;

export default Component.extend({
  classNames: ['loading-more-spinner'],
  retryer: null, // optional.. will display "Retrying in x seconds" text.

  _spin() {
    // Sometimes, `{{infinite-scroll}` within a rerender will change the
    // visibility of this component, destroying it before this fires in
    // `afterRender`. See also: loading-spinner
    if (!this.element) {
      return;
    }

    this.$().spin({
      lines: 12,
      length: 3,
      width: 2,
      radius: 6
    });
  },

  didInsertElement() {
    this._super(...arguments);
    run.schedule('afterRender', this, this._spin);
  }
});
