import Component from 'ember-component';
import run from 'ember-runloop';

export default Component.extend({
  classNames: ['loading-mask'],

  _spin() {
    // Sometimes, `{{infinite-scroll}` within a rerender will change the
    // visibility of this component, destroying it before this fires in
    // `afterRender`. See also: loading-more-spinner
    if (!this.element) {
      return;
    }

    this.$().spin();
  },

  didInsertElement() {
    this._super(...arguments);
    run.schedule('afterRender', this, this._spin);
  }
});
