import Component from 'ember-component';
import computed from 'ember-computed';
import RSVP from 'rsvp';

export default Component.extend({
  onConfirm() { return RSVP.resolve(); },
  onDismiss() {},
  isDeletingCollection: computed.notEmpty('collection'),
  actions: {
    confirm(collection) {
      let onDismiss = this.get('onDismiss');
      this.get('onConfirm')(collection).then(onDismiss);
    }
  }
});
