import Component from 'ember-component';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import computed from 'ember-computed';
import {
  STATE_PUBLIC,
  STATE_PRIVATE
} from 'web-client/utilities/video/playlist';

export const TEST_ATTR_CREATE_BUTTON = 'create-playlist-btn';
export const TEST_ATTR_FINALIZE_BUTTON = 'finalize-playlist-btn';
export const TEST_TITLE_INPUT_CLASS = 'js-test-title-input';

export default Component.extend(SendRouteActionMixin, {
  createCollectionHandler() {},
  isCreationDisabled: computed.empty('playlistTitle'),
  isPrivatePlaylist: false,
  playlistTitle: '',
  titleInputClass: `form__input ${TEST_TITLE_INPUT_CLASS}`,

  testAttrCreateButton: TEST_ATTR_CREATE_BUTTON,
  testAttrFinalizeButton: TEST_ATTR_FINALIZE_BUTTON,

  actions: {
    createPlaylist() {
      let title = this.get('playlistTitle');
      let isPrivate = this.get('isPrivatePlaylist');

      this.get('createCollectionHandler')({
        title,
        state: isPrivate ? STATE_PRIVATE : STATE_PUBLIC
      });
    }
  }
});
