import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { TYPE_VIDEO } from 'web-client/utilities/video/playlist-item';

export const TEST_ATTR_PLAYLIST_TITLE = 'edit-playlist-title';

export default Component.extend({
  notify: injectService(),
  routing: injectService(),
  store: injectService(),
  attributeBindings: ['testSelector:data-test-selector'],

  isAddingVideos: false,
  isItemsLoaded: false,
  playlist: null,
  playlistItems: null,
  testAttrPlaylistTitle: TEST_ATTR_PLAYLIST_TITLE,
  testSelector: null,
  isShowingMore: false,
  collectionStagedForDeletion: null,

  init() {
    this._super(...arguments);

    this.set('playlistItems', []);
    this.get('playlist').hasMany('items').load().then((items) => {
      this.set('isItemsLoaded', true);
      this.set('playlistItems', items);
    });
  },

  playlistItemIds: computed('playlistItems.[]', function() {
    let items = this.get('playlistItems');
    if (items.length === 0) {
      return [];
    }

    return items.map((item) => {
      return item.get('itemId');
    });
  }),

  actions: {
    openItemsModal() {
      this.set('isAddingItems', true);
    },
    closeItemsModal() {
      this.set('isAddingItems', false);
    },
    addItemToPlaylist(searchItem) {
      let playlist = this.get('playlist');
      let playlistItemsCount = playlist.get('items.length');
      let newVideoItem = this.get('store').createRecord('video-playlist-item', {
        type: TYPE_VIDEO
      });

      newVideoItem.set('playlist', playlist);
      newVideoItem.set('video', searchItem);
      newVideoItem.set('position', playlistItemsCount);
      newVideoItem.save().then(() => {
        playlist.get('items').pushObject(newVideoItem);
      }, () => {
        this.get('notify').error('Error adding item to playlist.');
      });
    },
    removeItemFromPlaylist(itemToRemove) {
      let playlist = this.get('playlist');
      let playlistItems = playlist.get('items');

      let matchingItem = playlistItems.find((playlistItem) => {
        let typeMatch = playlistItem.get('itemType') === TYPE_VIDEO;
        let idMatch = playlistItem.get('itemId') === itemToRemove.get('id');
        return typeMatch && idMatch;
      });

      let matchingItemPosition = matchingItem.get('position');

      playlistItems.forEach((item) => {
        if (item.get('position') > matchingItemPosition) {
          item.decrementProperty('position');
        }
      });

      matchingItem.deleteRecord();
      matchingItem.save();
    },
    toggleShowMore() {
      this.toggleProperty('isShowingMore');
    },
    stageCollectionForDeletion(collection) {
      this.set('collectionStagedForDeletion', collection);
    },
    deleteCollection(collection) {
      return collection.destroyRecord().then(() => {
        this.get('routing').transitionTo('manager.collections');
      });
    },
    clearCollectionStagedForDeletion() {
      this.set('collectionStagedForDeletion', null);
    }
  }
});
