import Component from 'ember-component';
import computed from 'ember-computed';

export default Component.extend({
  init() {
    this._super(...arguments);

    this.get('collectionsPaginator').fetchNextPage();
  },

  collectionsPaginator: null,
  collectionStagedForDeletion: null,

  moreItems: computed.not('collectionsPaginator.isComplete'),
  noItems: computed.equal('collectionsPaginator.items.length', 0),

  actions: {
    selectSortOption(option) {
      this.set('selectedSortOption', option);
    },
    stageCollectionForDeletion(collection) {
      this.set('collectionStagedForDeletion', collection);
    },
    deleteCollection(collection) {
      return collection.destroyRecord();
    },
    clearCollectionStagedForDeletion() {
      this.set('collectionStagedForDeletion', null);
    },
    loadMore() {
      this.get('collectionsPaginator').fetchNextPage();
    }
  }
});
