import Component from 'ember-component';

export const TEST_ATTR_PLAYLIST_ROW = 'edit-playlist-item-row';

export default Component.extend({
  removeItemFromPlaylist() {},
  attributeBindings: ['testSelector:data-test-selector'],
  classNames: ['playlist-card', 'playlist-editor-card', 'flex', 'flex--verticalCenter', 'mg-b-1'],
  isShowingMore: false,
  itemIsRemoved: false,
  testSelector: TEST_ATTR_PLAYLIST_ROW,
  actions: {
    toggleShowMore() {
      this.toggleProperty('isShowingMore');
    },
    removeItem() {
      let item = this.get('item.video');
      this.get('removeItemFromPlaylist')(item);
      this.toggleProperty('itemIsRemoved');
    }
  }
});
