import Component from 'ember-component';
import computed from 'ember-computed';

export default Component.extend({
  isAdded: false,
  isAdding: false,
  item: null,
  testSelector: '',

  addHandler() {},
  removeHandler() {},

  didUpdateAttrs({ newAttrs }) {
    if (newAttrs && newAttrs.isAdded) {
      this.set('isAdding', false);
    }
  },

  text: computed('isAdded', function() {
    return this.get('isAdded') ? 'Remove' : 'Add';
  }),

  actions: {
    onClick() {
      let item = this.get('item');
      if (this.get('isAdded')) {
        this.get('removeHandler')(item);
        return;
      }

      this.set('isAdding', true);
      this.get('addHandler')(item);
    }
  }
});
