import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { NOTIFICATION_TYPE } from 'web-client/models/notification';
import { isPresent } from 'ember-utils';
import run from 'ember-runloop';

export default Component.extend({

  session: injectService(),
  userLogo: computed.readOnly('session.userLogo'),
  channelFeed: computed.alias(`video.notifications.${NOTIFICATION_TYPE.CHANNEL_FEED}`),
  email: computed.alias(`video.notifications.${NOTIFICATION_TYPE.EMAIL}`),
  url: null,

  actions: {
    setCursorPosition(event = {}) {
      let $element = event.target;

      if ($element) {
        let length = $element.val();
        run.next(() => $element.setSelectionRange(length, length));
      }
    }
  },

  didInsertElement() {
    let customText = this.get('channelFeed.custom_text');

    if (!isPresent(customText)) {
      let url = this.get('url');
      let message = `${url}\n`;

      this.set('channelFeed.custom_text', message);
    }
  }
});
