import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { MIME_TYPE } from 'web-client/utilities/video-uploader/validate-video-file';

export default Component.extend({
  videoProcessor: injectService(),
  mimeType: MIME_TYPE,

  actions: {
    startVideoUpload(file) {
      this.get('videoProcessor').startVideoUpload(file, this.get('channelName'));
    },

    startEditingVideo(video) {
      this.set('_selectedEditorVideo', video);
    },

    stopEditingVideo() {
      if (this.get('_selectedEditorVideo')) {
        this.set('_selectedEditorVideo', null);
      } else {
        let unfinalizedVideos = this.get('videoProcessor.unfinalizedVideos');
        unfinalizedVideos.removeAt(0);
      }
    },

    deleteVideo(video) {
      return video.destroyRecord();
    }
  },

  inProgressVideos: computed('videos.@each.{isInProgress,isNew,createdAt}', function() {
    return this.get('videos')
      .filterBy('isInProgress')
      .sortBy('isNew','createdAt')
      .reverse();
  }),

  publishedVideos: computed('videos.@each.{isProcessed,recordedDate}', function() {
    return this.get('videos')
      .filterBy('isProcessed')
      .sortBy('recordedDate')
      .reverse();
  }),

  allVideos: computed.alias('videos'),

  currentEditorVideo: computed('_selectedEditorVideo', 'videoProcessor.unfinalizedVideos.[]', function() {
    let _selectedEditorVideo = this.get('_selectedEditorVideo');
    if (_selectedEditorVideo) {
      return _selectedEditorVideo;
    }

    let unfinalizedVideos = this.get('videoProcessor.unfinalizedVideos');
    if (unfinalizedVideos.length > 0) {
      return unfinalizedVideos[0];
    }

    return null;
  })
});
