import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { htmlSafe } from 'ember-string';
import { GB_LIMIT, MIME_TYPES } from 'web-client/utilities/video-uploader/validate-video-file';

export default Component.extend({
  store: injectService(),
  videoProcessor: injectService(),
  attributeBindings: ['safeStyle:style'],
  gigabyteLimit: GB_LIMIT,
  mimeType: MIME_TYPES,

  // Injected function
  onFileChange() {},

  safeStyle: computed('style', function() {
    return htmlSafe(this.get('style'));
  }),

  actions: {
    chooseFile(file) {
      this.get('onFileChange')(file);
    }
  }
});
