import EmberObject from 'ember-object';
import computed from 'ember-computed';

const CATEGORIES = [{
  id: 'games',
  icon: 'svg/nav-games',
  headerTitle: 'Games',
  separatorTitle: 'Games'
}, {
  id: 'channels',
  icon: 'svg/nav-channels',
  headerTitle: 'Live Broadcasts',
  separatorTitle: 'Live'
}, {
  id: 'users',
  icon: 'svg/nav-profile',
  headerTitle: 'Channels',
  separatorTitle: 'Channels'
}, {
  id: 'videos',
  icon: 'svg/nav-videos',
  headerTitle: 'Videos',
  separatorTitle: 'Videos'
}];

const Category = EmberObject.extend({
  init() {
    if (!this.search) {
      this.search = {};
    }
  },

  totalHitCount: computed.reads('search.totalHitCount'),
  hitCount: computed.reads('search.hits.length'),
  hits: computed.reads('search.hits'),
  hasHits: computed.bool('hitCount'),
  hasNoHits: computed.not('hasHits'),

  nextPage: computed('search.page', function() {
    return this.get('search.page') + 1;
  })
});

export default function buildCategories() {
  return CATEGORIES.map(config => Category.create(config));
}

export function buildCommunityCategory() {

  return Category.create({
    id: 'communities',
    icon: 'svg/nav-games',
    headerTitle: 'Communities',
    separatorTitle: 'Communities'
  });
}
