import Component from 'ember-component';
import EmberObject from 'ember-object';
import { assign } from 'ember-platform';

// Vod filter options
const DEFAULT_TYPE = 'All Videos';
const DEFAULT_DURATION = 'Any Length';
const DEFAULT_SORT = 'Popular';

export default Component.extend({
  // Read-only constants for options
  typeOptions: [DEFAULT_TYPE, 'Past Broadcasts', 'Uploads', 'Highlights'],
  durationOptions: [DEFAULT_DURATION, 'Short', 'Long'],
  sortOptions: [DEFAULT_SORT, 'Newest'],

  init() {
    this._super(...arguments);

    this.currentFilter = null;
    this.filterOptions = assign(EmberObject.create({
      type: DEFAULT_TYPE,
      duration: DEFAULT_DURATION,
      sort: DEFAULT_SORT
    }), this.get('filterOptions'));
  },

  didInsertElement() {
    this._super(...arguments);

    this.addEventListener('[data-filter]', 'clickoutside', (e) => {
      if (this.get('currentFilter') === e.currentTarget.getAttribute('data-filter')) {
        this.set('currentFilter', null);
      }
    });
  },

  actions: {
    setFilter(filter) {
      if (this.get('currentFilter') === filter) {
        this.set('currentFilter', null);
      } else {
        this.set('currentFilter', filter);
      }
    },

    updateOption(option, value) {
      this.filterOptions.set(option, value);
      this.get('updateFilterOptions')(this.filterOptions);
    }
  }
});
