/* globals Twitch, i18n */
import Ember from 'ember';

const { Component, inject } = Ember;

export default Component.extend({
  tagName: '',
  globals: inject.service(),

  didInsertElement() {
    // TODO: There should probably be a service emitting events to trigger `displayNotification` in the future
    if (this.get('globals.isUnsupportedBrowser')) {
      let first = i18n('Your browser is currently unsupported.');
      let link = i18n('Upgrade your browser');
      let last = i18n('for an improved Twitch experience!');
      this.displayNotification(`${first} <a href="http://www.browsehappy.com" target="_blank" rel="noopener">${link}</a> ${last}`);
    }
  },

  displayNotification(message) {
    Twitch.notify.notice(message, {
      layout: 'top',
      timeout: false,
      escape: false,
      animation: {
        open: {
          height: 'toggle'
        },
        close: {
          height: 'toggle'
        },
        easing: 'swing',
        speed: 150
      }
    });
  }
});
