import Component from 'ember-component';
import computed from 'ember-computed';

export default Component.extend({
  showPlayToggle: true,
  showPlaySwitch: false,
  isPlaying: true,

  isGameSelectorDisabled: computed('isPlaying', function () {
    return !this.get('isPlaying');
  }),

  handleGameClick() {},
  onGameChange() {},

  actions: {
    togglePlaySwitch() {
      this.toggleProperty('showPlaySwitch');
    },

    playingClick() {
      this.set('isPlaying', true);
      this.set('game', this.get('cachedGame'));
      this.set('showPlaySwitch', false);
    },

    notPlayingClick() {
      this.set('isPlaying', false);
      this.set('cachedGame', this.get('game'));
      this.set('game', '');
      this.set('showPlaySwitch', false);
    }
  }
});
