import Component from 'ember-component';
import Ember from 'ember';

const { $ } = Ember;

export default Component.extend({
  tagName: "div",
  classNames: ['draggable-dropzone'],
  _initDroppable() {
    let self = this;
    let scrollContainer = $('.tse-scroll-content', this.element);
    let scrollingDown;
    let SCROLL_SPEED = 600;

    let scrollPlaylist = function (pos, timing) {
      scrollContainer.stop().animate({
        'scrollTop': pos
      }, timing, 'linear');
    };

    $('.zone-container', this.element).sortable({
      revert: false,

      sort(event, ui) {
        let $self = $(this);

        // we should make the placeholder into a separate template
        $(ui.placeholder).removeClass('item');

        // don't use default scroll because it's terrible
        let containerTop = scrollContainer.offset().top;
        let containerHeight = scrollContainer.outerHeight();
        let containerBottom = containerTop + containerHeight;

        let helperTop = ui.helper.offset().top;
        let helperBottom = helperTop + ui.helper.outerHeight();

        let listFirstChild = $self.find('.editable').first();
        let listLastChild = $self.find('.editable').last();

        // Scroll interactions
        // scroll up
        if (helperTop < containerTop && helperTop > 0) {
          scrollingDown = false;
          scrollPlaylist(0, SCROLL_SPEED);
        } else {
          if (!scrollingDown) {
            scrollContainer.stop(true, false);
          }
        }

        // scroll down
        if (helperBottom > containerBottom) {
          scrollingDown = true;

          let contentBottom = $('.playlist-content', this.element).outerHeight() - containerHeight;
          scrollPlaylist(contentBottom, SCROLL_SPEED);

          scrollContainer.on('scroll', function () {
            let adjustedScrollTop = scrollContainer.scrollTop() + $('.js-playlist-drag-guide', this.element).outerHeight(true);
            if (adjustedScrollTop >= contentBottom) {
              // For very last element
              if (ui.helper.position().top > (listLastChild.position().top + (listLastChild.outerHeight() / 2))) {
                scrollContainer.off('scroll');
                $('.js-playlist-drag-guide').show();
                $(ui.placeholder).hide();
                scrollContainer.scrollTop(contentBottom);
              }
            }
          });

        } else if (scrollingDown) {
          scrollContainer.stop(true, false);
        }

        // Non Scroll Interactions
        if ($self.find('.editable').length > 0) {
          // Make droppable area for very first element more generous
          if (ui.helper.position().top > 0 && ui.helper.position().top < (listFirstChild.outerHeight() / 2)) {
            $('.ui-sortable-placeholder').insertBefore(listFirstChild);
          }
        }
      },

      receive(event, ui) {
        let indexes = {};
        let currentItem = $(this).data().uiSortable.currentItem;

        currentItem.data('id', Math.random());

        $(this).find('.playlist-item,.ui-draggable').each(function (index) {
          indexes[$(this).data('id')] = index;
        });
        $(this).sortable('cancel');
        self.sendAction('dropped', ui.item.data('content'), currentItem.data('id'), indexes);

        return false;
      },

      update(event, ui) {
        if (ui.item.data('content')) {
          $(this).sortable('cancel');
          return false;
        }

        let indexes = {};
        $(this).find('.playlist-item').each(function (index) {
          indexes[$(this).data('id')] = index;
        });

        self.sendAction('updateSortOrder', indexes);
      },

      beforeStop() {
        let adjustedScrollTop = scrollContainer.scrollTop() - $('.js-playlist-drag-guide', this.element).outerHeight(true);
        $('.manager').attr('data-playlistscroll', adjustedScrollTop);
      },

      containment: $(".playlist-container"),

      items: ".playlist-item",

      scroll: false // default scroll isn't great
    });

    this.get('parentView').send('initEnabled');
  },

  didInsertElement() {
    this._initDroppable();
  }
});
