import Component from 'ember-component';
import computed from 'ember-computed';
import { htmlSafe } from 'ember-string';

export default Component.extend({
  classNames: ['progress-bar'],

  style: computed("current", "total", function () {
    let current = Number(this.get('current'));
    let total = Number(this.get('total'));

    let percentProgress;
    if (current && total) {
      percentProgress = current / total * 100;
    } else {
      percentProgress = 0;
    }

    return htmlSafe(`width: ${percentProgress}%`);
  })
});
