import Component from 'ember-component';
import computed from 'ember-computed';
import urlParams from 'web-client/utilities/url-params';
import injectService from 'ember-service/inject';

export default Component.extend({
  globals: injectService(),
  session: injectService(),
  urlParams,

  broadcasterId: computed.readOnly('urlParams.br_id'),
  tuidValidator: computed.readOnly('urlParams.tv'),
  isBitsEnabled: computed.readOnly('globals.isBitsEnabled'),
  purchaseBitsUrl: computed.readOnly('globals.purchaseBitsUrl'),

  fullUrl: computed('purchaseBitsUrl', 'asin', 'session.isAuthenticated', 'broadcasterId', 'tuidValidator', function() {
    let url = `${this.get('purchaseBitsUrl')}/checkout/summary?embed=true`;

    if (this.get('asin')) {
      url += `&asin=${this.get('asin')}`;
    }

    if (this.get('session.isAuthenticated')) {
      url += `&tuid=${this.get('session.userData.id')}`;
    }

    if (this.get('broadcasterId')) {
      url += `&br_id=${this.get('broadcasterId')}`;
    }

    if (this.get('tuidValidator')) {
      url += `&tv=${this.get('tuidValidator')}`;
    }

    return url;
  })

});
