import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { JTV_USER_PICTURES_404_USER_70X70_URL } from 'web-client/utilities/urls/static-cdn';

export default Component.extend({
  recommendedChannels: injectService(),
  channels: computed.alias('recommendedChannels.channels'),

  classNames: ['js-recommended-channels', 'recommended-channels', 'is-drawer-closed--hide'],

  defaultChannelLogo: JTV_USER_PICTURES_404_USER_70X70_URL,

  actions: {
    onClickChannel(channel) {
      this.sendAction('handleStreamClick', channel);
    }
  }
});
