import Component from 'ember-component';

/*
  Simple save button component.

  Properties:
    class: string of classes to customize save button
    save: action triggered when save button is clicked
    isSaving: boolean to render saving state. Disables button.
    type: defaults to 'button'
*/
export default Component.extend({
  tagName: 'button',
  isSaving: false,
  type: 'button', // prevent default form submission behavior
  classNames: ['button', 'submit'],
  classNameBindings: ['isSaving:saving'],
  attributeBindings: ['isSaving:disabled', 'type'],

  click: function () {
    if (!this.get('isSaving')) {
      this.get('save')();
    }
  }
});
