import Component from 'ember-component';
import computed from 'ember-computed';
import { AUTHOR_TEXT_FORMAT } from "../extension-details/component";

export default Component.extend({
  extension: null,

  authorText: computed('extension.authorName', function() {
    let author = this.get('extension.authorName');
    if (author) {
      let translatedString = AUTHOR_TEXT_FORMAT;
      return translatedString.replace('{{author}}', author);
    }

    return '';
  })
});
