/* globals i18n */
import Component from 'ember-component';
import computed from 'ember-computed';

export const AUTHOR_TEXT_FORMAT = i18n('Created by {{author}}');

export default Component.extend({
  extension: null,
  isInstalled: false,

  installedExtension: null,
  extensionToUninstall: null,

  installExtension() {},
  continueBrowsing() {},

  currentImageIndex: 0,

  galleryIconIndicies: computed('extension.screenshotUrls', function () {
    let images = this.get('extension.screenshotUrls') || [];
    return images.slice(1).map((_, index) => index);
  }),

  showAdditionalInfo: computed.or('extension.supportEmail', 'extension.authorName'),

  authorText: computed('extension.authorName', function() {
    let author = this.get('extension.authorName');
    if (author) {
      let translatedString = AUTHOR_TEXT_FORMAT;
      return translatedString.replace('{{author}}', author);
    }

    return '';
  }),

  actions: {
    onInstallClicked() {
      let callback = this.get('installExtension');
      let extension = this.get('extension');
      if (!extension || !callback) {
        return;
      }

      let result = callback(extension);
      if (result && result.then) {
        result.then(() => {
          this.set('installedExtension', extension);
        });
      }
    },

    onUninstallClicked() {
      this.set('extensionToUninstall', this.get('extensionInstallation'));
    },

    onScrollGallery(index) {
      this.set('currentImageIndex', index);

      let area = this.$('.js-ext-screens-scroller');
      let element = this.$('.js-ext-screens-item')[index];
      let areaRect = area[0].getBoundingClientRect();
      let elementRect = element.getBoundingClientRect();
      area.animate({
        left: `${areaRect.left - elementRect.left}px`
      }, 300);
    }
  }
});
