import Component from 'ember-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';

export default Component.extend({
  session: injectService(),
  channel: computed.alias('session.userData.login'),

  renderInPlace: false,

  onProceed() {},
  onCancel() {},

  installedExtension: null,
  extensionToUninstall: null,

  actions: {
    closeModal() {
      this.set('installedExtension', null);
      this.set('extensionToUninstall', null);
      this.get('onCancel')();
    },

    proceed() {
      let extension = this.get('extensionToUninstall');
      this.set('extensionToUninstall', null);
      this.get('onProceed')(extension);
    }
  }
});
