/* globals i18n */
import Component from 'ember-component';
import computed from 'ember-computed';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';

// TODO(rudderm): Convert to new i18n flow
const AUTHOR_TEXT_FORMAT = i18n('by {{author}}');
const INSTALL_COUNT_FORMAT = i18n('{{installCount}} users');

export default Component.extend(SendRouteActionMixin, {
  extension: null,

  installExtension() {},

  authorText: computed('extension.author', function () {
    let author = this.get('extension.author');
    if (author) {
      let translatedString = AUTHOR_TEXT_FORMAT;
      return translatedString.replace('{{author}}', author);
    }

    return '';
  }),

  installationCountText: computed('extension.installationCount', function () {
    let installCount = this.get('extension.installationCount') || 0;
    return INSTALL_COUNT_FORMAT.replace('{{installCount}}', installCount.toLocaleString());
  }),

  actions: {
    onInstallClicked() {
      let extension = this.get('extension');
      let callback = this.get('installExtension');
      if (extension && callback) {
        callback(extension);
      }
    }
  }
});
