/* globals i18n */
import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import EmberObject from 'ember-object';
import { htmlSafe } from 'ember-string';

// TODO(rudderm): Migrate to new i18n flow
const ACTIVATE_LABEL_FMT = i18n('Set as {{slot}}');
const EXTENSION_TO_REPLACE_BODY_FMT = i18n('<strong>{{extensionName}}</strong> on {{extensionSlot}}');
const ACTIVATED_EXTENSION_BODY_FMT = i18n('The extension <strong>{{extensionName}}</strong> is now active on panel slot <strong>{{extensionSlot}}</strong>');

const ExtensionSlot = EmberObject.extend({
  id: '',
  label: computed('id', function() {
    let id = this.get('id');
    return ACTIVATE_LABEL_FMT.replace('{{slot}}', id);
  })
});

export default Component.extend({
  api: injectService(),

  allExtensions: [],
  installedExtensions: [],
  extensionPanels: [],

  activeExtensions: computed('installedExtensions', function() {
    let installedExtensions = this.get('installedExtensions') || [];
    return installedExtensions.filter(ext => ext.get('active'));
  }),

  availableSlots: computed('extensionPanels', function() {
    let panels = this.get('extensionPanels');
    return panels.map(function (panel) {
      return ExtensionSlot.create({ id: panel.kind });
    });
  }),

  installExtension() {},
  uninstallExtension() {},
  configureExtension() {},
  activateExtension() {},
  deactivateExtension() {},

  installedExtension: null,
  activatedExtension: null,
  extensionToUninstall: null,
  extensionToReplace: null,
  extensionToActivate: null,

  extensionToReplaceBodyText: computed('extensionToReplace', function() {
    let extensionName = this.get('extensionToReplace.extension.name');
    let extensionSlot = this.get('extensionToReplace.extension.config.slot');
    let result = EXTENSION_TO_REPLACE_BODY_FMT.replace('{{extensionName}}', extensionName).replace('{{extensionSlot}}', extensionSlot);
    return htmlSafe(result);
  }),

  activatedExtensionBodyText: computed('activatedExtension', function() {
    let extensionName = this.get('activatedExtension.extension.name');
    let extensionSlot = this.get('activatedExtension.config.slot');
    let result = ACTIVATED_EXTENSION_BODY_FMT.replace('{{extensionName}}', extensionName).replace('{{extensionSlot}}', extensionSlot);
    return htmlSafe(result);
  }),

  availableExtensions: computed('allExtensions', 'installedExtensions', function() {
    let allExtensions = this.get('allExtensions') || [];
    let installedExtensions = this.get('installedExtensions') || [];

    return allExtensions.filter((extensionA) => {
      return !installedExtensions.any((extensionB) => {
        return extensionB.get('extension.id') === extensionA.id;
      });
    });
  }),

  init() {
    this._super(...arguments);

    let allExtensions = this.get('allExtensions');
    if (!allExtensions) {
      this.set('allExtensions', []);
    }

    let installedExtensions = this.get('installedExtensions');
    if (!installedExtensions) {
      this.set('installedExtensions', []);
    }
  },

  actions: {
    closeExtensionReplaceDialog() {
      this.set('extensionToActivate', null);
      this.set('extensionToReplace', null);
    },
    closeExtensionActivationDialog() {
      this.set('activatedExtension', null);
    },
    replaceExtension() {
      let extensionToActivate = this.get('extensionToActivate');
      let extensionToReplace = this.get('extensionToReplace');
      let slot = extensionToReplace.get('extension.config.slot');

      let deactivateExtension = this.get('deactivateExtension');
      let activateExtension = this.get('activateExtension');
      deactivateExtension(extensionToReplace).then(() => {
        return activateExtension(extensionToActivate, { slot });
      }).then(() => {
        if (this.isDestroyed) { return; }
        this.set('extensionToActivate', null);
        this.set('extensionToReplace', null);
        return extensionToActivate.reload();
      }).then(() => {
        if (this.isDestroyed) { return; }
        this.set('activatedExtension', extensionToActivate);
      });
    },
    installExtension(extension) {
      this.get('installExtension')(extension).then(() => {
        if (this.isDestroyed) { return; }
        this.set('installedExtension', extension);
      });
    },
    uninstallExtension(extension) {
      this.set('extensionToUninstall', extension);
    },
    configureExtension(extension) {
      this.get('configureExtension')(extension);
    },
    activateExtension(extension, config) {
      if (config.slot) {
        let activeExtensions = this.get('activeExtensions') || [];
        let conflictingExtension = activeExtensions.find(ext => ext.get('extension.config.slot') === config.slot);

        if (conflictingExtension) {
          this.set('extensionToActivate', extension);
          this.set('extensionToReplace', conflictingExtension);
          return;
        }
      }

      let activateExtension = this.get('activateExtension');
      return activateExtension(extension, config).then(() => {
        if (this.isDestroyed) { return; }
        this.set('activatedExtension', extension);
      });
    },
    deactivateExtension(extension) {
      this.get('deactivateExtension')(extension);
    }
  }
});
