/* globals i18n */
import Component from 'ember-component';
import computed from 'ember-computed';

const SLOT_UNDEFINED_LABEL = i18n('none');
const ACTIVE_LABEL_FMT = i18n('ACTIVE ({{slot}})');

export default Component.extend({
  installedExtension: null,
  availableSlots: [],

  activateExtension() {},
  configureExtension() {},
  deactivateExtension() {},
  uninstallExtension() {},

  extension: computed.alias('installedExtension.extension'),

  activeLabel: computed('installedExtension.config.slot', function () {
    let slot = this.get('installedExtension.config.slot') || SLOT_UNDEFINED_LABEL;
    return ACTIVE_LABEL_FMT.replace('{{slot}}', slot);
  }),

  actions: {
    onActivateClicked(slot) {
      let extension = this.get('installedExtension');
      let callback = this.get('activateExtension');
      callback(extension, { slot: slot.get('extension.id') });
    },

    onActivateNewClicked() {
      let extension = this.get('installedExtension');
      let callback = this.get('activateExtension');
      callback(extension, { slot: null });
    },

    onConfigClicked() {
      let extension = this.get('installedExtension');
      let callback = this.get('configureExtension');
      callback(extension);
    },

    onDeactivateClicked() {
      let extension = this.get('installedExtension');
      let callback = this.get('deactivateExtension');
      callback(extension);
    },

    onUninstallClicked() {
      let extension = this.get('installedExtension');
      let callback = this.get('uninstallExtension');
      callback(extension);
    }
  }
});
