/* globals Twitch, i18n */

import Component from 'ember-component';
import injectService from 'ember-service/inject';
import on from 'ember-evented/on';

const DEFAULT_LANGUAGE = 'en';

const DISPLAY_NAME_MICRO_COPY = {
  'en': 'Customize the capitalization of your display name or change it to contain English characters! Setting an English display name is a permanent change — requests to undo it will not be honored! Display names that do not adhere to Twitch Rules of Conduct may result in an indefinite suspension of your account.',
  'ko': '영어 닉네임의 대소문자를 자유롭게 바꾸실 수 있고 한국어 로 닉네임을 정하실 수 있습니다. 단한국어 로 닉네임을 변경하실 경우 영구적으로 적용이 되니 꼭 신중하게 정해주시길 바랍니다. 트위치 이용정책에 어긋나는 부적절한 닉네임은 영구정지 대상이 될 수 있으니 명심하시길 바랍니다.',
  'ja': '表示名の大文字小文字を変更したり、日本語の文字を含む名前に変更しましょう！ただし、日本語の表示名への変更は永続的なものです。再変更のご要望には応じかねますので、ご注意ください！なお、Twitch倫理規定に反する表示名を設定した場合、アカウントは無期限停止処分の対象となります。',
  'zh': '请自定义显示名称的大小写，或将其更改为包含中文 简体字符！设置中文 简体显示名称属于永久性更改，不接受撤消更改请求！未遵守 Twitch 行为准则的显示名称将导致账户无限期暂挂。',
  'zh-cn': '请自定义显示名称的大小写，或将其更改为包含中文 简体字符！设置中文 简体显示名称属于永久性更改，不接受撤消更改请求！未遵守 Twitch 行为准则的显示名称将导致账户无限期暂挂。',
  'zh-tw': '請自訂您聊天室裡的顯示暱稱，請注意，需要使用全 中文 繁體 字才可以唷！設定 中文 繁體 暱稱是永久性的變更，以後是不能改的喔! 請謹慎確認。',
  'zh-hk': '請自訂您聊天室裡的顯示暱稱，請注意，需要使用全 中文 繁體 字才可以唷！設定 中文 繁體 暱稱是永久性的變更，以後是不能改的喔! 請謹慎確認。'
};

export default Component.extend({
  settings: injectService('profile-settings'),
  notify: injectService(),
  tracking: injectService(),
  classNames: ['cl-subsection'],
  session: injectService(),

  setStrings: on('init', function() {
    let userLanguage = Twitch.receivedLanguage || DEFAULT_LANGUAGE;
    if (['ko', 'ja', 'zh', 'zh-cn', 'zh-tw', 'zh-hk'].includes(userLanguage)) {
      this.set('displayNameMicroCopy', DISPLAY_NAME_MICRO_COPY[userLanguage]);
    }
  }),

  actions: {
    updateSettings() {
      let fileInput = this.$('#user_profile_image');
      let file = fileInput[0].files[0];
      let settings = this.get('settings');
      let user = this.get('user');
      let notify = this.get('notify');
      let tracking = this.get('tracking');
      let promise;

      this.set('isLoading', true);

      promise = settings.updateProfileSettings(file).then(() => {
        // Do we need these inside of promise callbacks?
        if (this.isDestroyed) { return; }
        if (file) {
          tracking.trackEvent({
            event: 'profile_picture_upload',
            data: { 'profile_picture_previously_empty': user.get('logo') ? true : false }
          });
        }
      });

      return promise.then(() => {
        if (this.isDestroyed) { return; }
        notify.success(i18n('Profile changes have been saved'));
      }, (error) => {
        notify.error(i18n('Unable to update profile. ') + JSON.parse(error.responseText).message);
        throw error;
      }).finally(() => {
        if (this.isDestroyed) { return; }
        this.set('isLoading', false);
      });
    },

    verifyEmail() {
      let notify = this.get('notify');
      let tracking = this.get('tracking');

      this.get('settings').verifyEmail().then(() => {
        tracking.trackEvent({
          services: ['mixpanel'],
          event: 'email_notice',
          data: { type: 'valid_verify' }
        });
        notify.success(i18n('Email sent!'));
      }, (data) => {
        tracking.trackEvent({
          services: ['mixpanel'],
          event: 'email_notice',
          data: { type: 'invalid_verify' }
        });
        notify.error(i18n(data.responseText));
      });
    }
  }
});
