import Component from 'ember-component';
import env from 'web-client/config/environment';

const SIXTY_SECONDS = env.creative.sizmek.oneMin;
const FIVE_MINUTES = env.creative.sizmek.fiveMins;
const ONLOAD_PIXEL_URL_V1 = env.creative.sizmek.version1.onLoadPixel;
const ONE_MIN_PIXEL_URL_V1 = env.creative.sizmek.version1.oneMinPixel;
const FIVE_MIN_PIXEL_URL_V1 = env.creative.sizmek.version1.fiveMinPixel;
const ONLOAD_PIXEL_URL_V2 = env.creative.sizmek.version2.onLoadPixel;
const ONE_MIN_PIXEL_URL_V2 = env.creative.sizmek.version2.oneMinPixel;
const FIVE_MIN_PIXEL_URL_V2 = env.creative.sizmek.version2.fiveMinPixel;

export default Component.extend({
  trackingPixelURLV1: ONLOAD_PIXEL_URL_V1,
  trackingPixelURLV2: ONLOAD_PIXEL_URL_V2,

  init() {
    this._super(...arguments);

    this.runTask(() => {
      this.set('trackingPixelURLV1', ONE_MIN_PIXEL_URL_V1);
      this.set('trackingPixelURLV2', ONE_MIN_PIXEL_URL_V2);
    }, SIXTY_SECONDS);

    this.runTask(() => {
      this.set('trackingPixelURLV1', FIVE_MIN_PIXEL_URL_V1);
      this.set('trackingPixelURLV2', FIVE_MIN_PIXEL_URL_V2);
    }, FIVE_MINUTES);
  }
});
