import Component from 'ember-component';
import injectService from 'ember-service/inject';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import computed from 'ember-computed';

export default Component.extend(SendRouteActionMixin, {
  layout: injectService(),

  isVisible: computed('friendLocation', 'channel.id', function() {
    return this.get('friendLocation') !== this.get('channel.id');
  }),

  actions: {
    joinActivity() {
      this.get('layout').trigger('dismissProfileCard');
      this.sendRouteAction('handleStreamClick', {id: this.get('friendLocation')});
    }
  }
});
