import injectService from 'ember-service/inject';
import Component from 'ember-component';
import computed from 'ember-computed';
import observer from 'ember-metal/observer';
import on from 'ember-evented/on';

const MAX_LENGTH = 5;

export default Component.extend({
  session: injectService(),
  layout: injectService(),
  recommended: injectService('twitch-friends-list/recommended'),
  tracking: injectService(),

  initRecommended: on('init', function () {
    this.get('recommended').fetchRecommendations();
  }),
  limitedRecommendedList: computed('recommended.recommendedUsers.[]', function () {
    return this.get('recommended.recommendedUsers').slice(0, MAX_LENGTH);
  }),

  _limitedRecommendedListTracking: observer('recommended.recommendedUsers.[]', function () {
    let tracking = this.get('tracking');
    let limitedRecommendedUsers = this.get('recommended.recommendedUsers').slice(0, MAX_LENGTH);

    let trackingObject = {
      login: this.get('session.userData.login'),
      rec_source: this.get('recommended.recommendedSource')
    };

    limitedRecommendedUsers.forEach((user, index) => {
      let i = index + 1;
      trackingObject[`recommended_login_${i}`] = user.get('login');
    });

    tracking.trackEvent({
      services: ['spade'],
      event: 'recommended_friend_display',
      data: trackingObject
    });
  })
});
