/* globals i18n */
import Component from 'ember-component';
import computed from 'ember-computed';

export default Component.extend({
  searchResults: [],
  friendResults: [],

  isEmptySearch: computed('searchResults.length', 'friendResults.length', 'isLoading', function() {
    return !this.get('searchResults.length') &&
           !this.get('friendResults.length') &&
           !this.get('isLoading');
  }),
  errorText: computed('query', function() {
    let translation = i18n("Sorry, we couldn't find anyone named \"{{login}}\"");
    return translation.replace("{{login}}", this.get("query"));
  })
});
