import Component from 'ember-component';

export default Component.extend({
  didInsertElement() {
    let sortControl = this.sortControl = this.$('.js-sort-control');
    let sortOptions = sortControl.siblings('.js-sort-options');

    sortControl.on(`click.${this.elementId}`, () => {
      sortOptions.toggle();
    });

    sortControl.on(`clickoutside.${this.elementId}`, () => {
      sortOptions.hide();
    });
  },

  willDestroyElement() {
    this.sortControl.off(`click.${this.elementId}`);
    this.sortControl.off(`clickoutside.${this.elementId}`);
  }
});
