import Component from 'ember-component';
import computed from 'ember-computed';
import { htmlSafe } from 'ember-string';

export default Component.extend({
  classNames: ['split-pane'],
  attributeBindings: ['style'],

  style: computed('width', 'divider', function() {
    let width = this.get('width');
    let widthStyle = width ? `width: ${width}px;` : '';

    let divider = this.get('divider');
    let dividerStyle = divider ? `margin-right: ${divider}px;` : '';

    return htmlSafe(`${widthStyle}${dividerStyle}`);
  })
});
