/* globals i18n */
import Ember from 'ember';

const { Component } = Ember;

export default Component.extend({
  classNames: ['items'],
  streams: null,
  emptyMessage: i18n('No Channels Live'),

  init() {
    this._super(...arguments);
    if (!this.get('streams')) {
      throw new Error('No streams provided to `stream-list` component');
    }
  },

  actions: {
    loadMore: function () {
      let customLoadMore = this.get('loadMore');
      if (customLoadMore) {
        return customLoadMore(...arguments);
      }

      this.get('streams').loadMore();
    }
  }
});
