import Component from 'ember-component';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';
import { scheduleOnce } from 'ember-runloop';

export default Component.extend(SendRouteActionMixin, InteractivityDeferredComponent, {
  classNames: ['qa-stream-preview'],

  showTags: false,

  didInsertElement() {
    this._super(...arguments);
    scheduleOnce('afterRender', this, this.reportInteractive);
  },

  actions: {
    handleStreamClick(position) {
      let stream = this.get('stream');

      this.sendRouteAction('handleStreamClick', stream, position);
    },

    handleGameThumbnailClick() {
      let stream = this.get('stream');

      this.sendRouteAction('handleGameThumbnailClick', stream);
    }
  }
});
