/* globals Twitch */
import Component from 'ember-component';
import computed from 'ember-computed';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';

export default Component.extend(SendRouteActionMixin, {
  tagName: 'li',
  classNames: ['card-carousel__item'],

  stream: computed.alias('content'),

  channelHref: computed('stream.channel.name', function () {
    return Twitch.uri.channel(this.get('stream.channel.name'));
  }),

  actions: {
    handleStreamClick(position) {
      let stream = this.get('stream');
      this.sendRouteAction('handleStreamClick', stream, position);
    },

    handleGameThumbnailClick() {
      let stream = this.get('stream');
      // route handles both vods and streams, so needs game in the js object
      stream.game = this.get('stream.game');
      this.sendRouteAction('handleGameThumbnailClick', stream);
    }
  }
});
