/* globals Twitch */
import computed from 'ember-computed';
import Component from 'ember-component';

export default Component.extend({
  tagName: 'span',

  href: computed('channel.id', 'campaign', function () {
    return Twitch.uri.subscribe(this.get('channel.id'), this.get('campaign'));
  }),
  
  actions: {
    trackLinkClick(linkActionName){
      this.get('trackSubscribeButtonAction')(linkActionName, this);
    }
  }
});
