import Component from 'ember-component';
import computed from 'ember-computed';

export default Component.extend({
  classNames: ['tab'],
  classNameBindings: ['isHidden:hidden'],

  tabProps: computed(function() { return {}; }),

  init() {
    this._super(...arguments);
    let registerTab = this.get('tabProps.registerTab');
    if (registerTab) {
      registerTab(this);
    }
  },

  isActive: computed('tabProps.activeTab', function() {
    return this === this.get('tabProps.activeTab');
  }),

  isHidden: computed('isActive', 'tabProps.usingHidden', function() {
    return this.get('tabProps.usingHidden') && !this.get('isActive');
  }),

  shouldRender: computed.or('isActive', 'isHidden')
});
