import Component from 'ember-component';
import Ember from 'ember';
import computed from 'ember-computed';

const { htmlSafe } = Ember.String;

export default Component.extend({
  tagName: 'li',
  classNames: ['tabbed-split__panel'],
  attributeBindings: ['widthStyle:style'],
  _registeredLabel: "",

  didReceiveAttrs() {
    this._super(...arguments);
    if (this.get('label') !== this.get('_registeredLabel')) {
      let register = this.get('layoutSettings.registerTab');
      let newLabel = this.get('label');
      if (register) {
        register(newLabel);
        this.set('_registeredLabel', newLabel);
      }
    }
  },

  widthStyle: computed('isFlex', 'layoutSettings.flexWidth', 'layoutSettings.chunkWidth', function () {
    let width;
    if (this.get('isFlex')) {
      width = this.get('layoutSettings.flexWidth');
    } else {
      width = this.get('layoutSettings.chunkWidth');
    }
    return htmlSafe(`width: ${width}px;`);
  }),

  isTabbed: computed.alias('layoutSettings.isTabbed'),
  isShown: computed('isTabbed', 'layoutSettings.activeTab', 'label', function () {
    let isTabbed = this.get('isTabbed');
    let activeTab = this.get('layoutSettings.activeTab');
    let label = this.get('label');

    return !isTabbed || activeTab === label;
  })
});
