import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { TOP_NAV_URL as primeURL } from 'web-client/utilities/urls/prime-urls';

export default Component.extend({
  premiumGeo: injectService(),
  session: injectService(),

  primeURL,

  showPrimeOffer: computed('premiumGeo.showPrimeContent', 'session.userData.has_premium', function () {
    return this.get('premiumGeo.showPrimeContent') && !this.get('session.userData.has_premium');
  }),

  showTurboOffer: computed('showPrimeOffer', 'session.userData.has_turbo', function () {
    return !this.get('showPrimeOffer') && !this.get('session.userData.has_turbo');
  })
});
