import Component from 'ember-component';
import CarouselMixin from 'web-client/mixins/carousel';
import CarouselTrackingMixin from 'web-client/mixins/carousel-tracking';
import computed from 'ember-computed';
import VodCoviewsTrackingMixin from 'web-client/mixins/vod-coviews/tracking';
import injectService from 'ember-service/inject';

const CAROUSEL_SELECTOR = '.card-carousel__container';
const CAROUSEL_BUTTON_SELECTOR = '.card-carousel__nav button';

export default Component.extend(CarouselMixin, CarouselTrackingMixin, VodCoviewsTrackingMixin, {
  tracking: injectService(),

  carouselSelector: CAROUSEL_SELECTOR,
  carouselButtonSelector: CAROUSEL_BUTTON_SELECTOR,
  showItemBoxart: true,

  // tracking params
  sourceContent: null,
  sectionIndex: null,

  numRecsViewable: computed('recsToShow', 'streamsPerRow', function () {
    return Math.min(this.get('items.length'), this.get('streamsPerRow'));
  }),

  recsToShow: computed.filter('items', function(item) {
    return item.id !== this.get('sourceContent.id');
  }),

  // NOTE: live content does not have broadcast_type set.
  sourceContentBroadcastType: computed('sourceContent', 'sourceContentType', function() {
    let broadcastType = this.get('sourceContent.broadcast_type');
    if (typeof broadcastType === 'string') {
      return broadcastType;
    }
    return this.get('sourceContentType');
  }),

  sourceContentVodId: computed('sourceContent', function() {
    let broadcastType = this.get('sourceContent.broadcast_type');
    if (typeof broadcastType === 'string') {
      return this.get('sourceContent.id');
    }
  }),

  didReceiveAttrs() {
    if (this.get('trackCoviews')) {
      this.trackCoviewRecommendation();
    }

    let itemIds = this.get('items').map((item) => { return item.id; });
    this.trackItemSectionLoad(itemIds, this.get('sectionIndex'));

    this.get('items').forEach((item) => {
      item._isCarousel = true;
      item._carouselContent = this.get('trackingContent');
      item._sourceGame = this.get('sourceContent.game');
      item._sourceVodId = this.get('sourceContentVodId');
      item._sourceChannel = this.get('sourceContent.name');
      item._sourceItemType = this.get('sourceContentBroadcastType');
      item._carouselSectionIndex = this.get('sectionIndex');
    });
  }

});
