import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNames: ['inline-block'],
  communities: injectService(),

  //passed in properties
  channel: null,

  // internal properties
  community: null,

  init() {
    this._super(...arguments);
    this.get('communities').getChannelCommunity(this.get('channel._id')).then(result => {
      if (this.isDestroyed) { return; }

      this.set('community', result);
    });
  }
});
