/* globals Twitch, i18n */
import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import $ from 'jquery';

const TRANSLATED_REPORT_TITLE = i18n('Report {{name}}');
const TRANSLATED_REPORT_THANK_YOU = i18n('Thank you for your report.');

export default Component.extend(SendRouteActionMixin, {
  communities: injectService(),
  session: injectService(),
  routing: injectService(),
  bannerShowBalloon: false,
  avatarShowBalloon: false,
  isLoading: true,
  showActions: false,
  report: {
    isLoading: false,
    error: false,
    description: '',
    reasons: [],
    reason: ''
  },

  init() {
    this._super(...arguments);

    this.set('communities.communityInfo', this.get('communityInfo'));

    let banCommunityText = i18n('Are you sure you want to ban {{name}}?');
    banCommunityText = banCommunityText.replace('{{name}}', this.get('communities.communityInfo.name'));
    this.set('banCommunityText', banCommunityText);

    this.get('communities').checkPermission(this.get('communities.communityInfo._id')).then((permissions) => {
      if (this.isDestroyed) { return; }
      this.set('communities.permissions', permissions);
    });
  },

  reportTitle: computed('communities.communityInfo.name', function() {
    return TRANSLATED_REPORT_TITLE.replace('{{name}}', this.get('communities.communityInfo.name'));
  }),

  actions: {
    toggleEditingMode(isEditing) {
      if (!this.get('communities.isEditing')) {
        this.set('bannerShowBalloon', false);
        this.set('avatarShowBalloon', false);
      }

      this.set('communities.isEditing', isEditing);
    },

    setModerationMode(isEditingMods) {
      this.set('isEditingMods', isEditingMods);
      if (isEditingMods) {
        this.get('routing').transitionTo('communities.moderation-log', this.get('communities.communityInfo.name'));
      } else {
        this.get('routing').transitionTo('communities.community', this.get('communities.communityInfo.name'));
      }
    },

    toggleActions() {
      this.set('showActions', !this.get('showActions'));
    },

    banCommunity() {
      this.get('communities').banCommunity().then(() => {
        if (this.isDestroyed) { return; }
        this.get('routing').transitionTo('directory.communities');
      });
      this.closeModal();
    },

    openBanModal() {
      this.sendRouteAction('openInModal', `communities/banCommunity`, this);
    },

    openReportModal() {
      if (!this.get('session').isAuthenticated) {
        $.login({mpSourceAction: "community-report"});
        return;
      }

      this.set('showActions', false);
      this.set('report.error', false);
      if (this.get('report.reasons').length === 0) {
        this.set('report.isLoading', true);
        this.get('communities').getReportReasons().then(reasons => {
          if (this.isDestroyed) { return; }
          this.set('report.reasons', reasons);
          this.set('report.isLoading', false);
        });
      }
      this.sendRouteAction('openInModal', `communities/reportCommunity`, this);
    },

    closeModal() {
      this.sendRouteAction('closeModal', ...arguments);
    },

    selectReportReason(value) {
      this.set('report.reason', value);
    },

    reportCommunity() {
      if (!this.get('report.description') && !this.get('report.reason')) {
        return;
      }
      this.set('report.isLoading', true);
      this.get('communities').reportCommunity(this.get('report')).then(() => {
        if (this.isDestroyed) { return; }
        Twitch.notify.success(TRANSLATED_REPORT_THANK_YOU);
        this.set('report.isLoading', false);
        this.sendRouteAction('closeModal', ...arguments);
      }, () => {
        if (this.isDestroyed) { return; }
        this.set('report.error', true);
        this.set('report.isLoading', false);
      });
    }
  }
});
