import Component from 'ember-component';
import { JTV_USER_PICTURES_404_USER_70X70_URL } from 'web-client/utilities/urls/static-cdn';
import BanTimeoutModalMixin from 'web-client/mixins/communities/ban-or-timeout-modal';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';
import computed from 'ember-computed';
import run from 'ember-runloop';

export default Component.extend(BanTimeoutModalMixin, InteractivityDeferredComponent, {
  user: null,
  isError: false,

  userId: computed.alias('user.user_id'), // Needed for BanTimeoutModalMixin
  userLogin: computed.alias('user.name'), // Needed for BanTimeoutModalMixin
  userDisplayName: computed.alias('user.display_name'), // Needed for BanTimeoutModalMixin

  init() {
    this._super(...arguments);
    this.set('avatarUrl', this.get('user.avatar_image_url') || JTV_USER_PICTURES_404_USER_70X70_URL);
  },

  didInsertElement() {
    this._super();
    run.scheduleOnce('afterRender', this, this.reportInteractive);
  },

  timeoutUserCallback(duration) {
    this.addTimeoutCb({ user: this.get('user'), duration });
  },

  banUserCallback() {
    this.addBanItem(this.get('user'));
  }
});
