import Component from 'ember-component';

export default Component.extend({
  users: null,
  bannedChannels: null,

  willRender() {
    if (this.get('users') && this.get('bannedChannels')) {
      let bannedChannels = this.get('bannedChannels');
      this.get('users').forEach(function(user) {
        let bannedChannelFound = bannedChannels.filter(function(banned) {
          return banned.name === user.name;
        });
        user.isBanned = bannedChannelFound.length;
      });
    }
  }
});
