/* globals Twitch, i18n */
import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

const SAVE_SUCCESS = i18n('Your moderation email has been updated!');
const SAVE_ERROR = i18n('There was a problem updating your new settings. Please try again.');

export default Component.extend({
  communities: injectService(),
  communityInfo: computed.readOnly('communities.communityInfo'),

  actions: {
    saveEmail() {
      this.get('communities').updateCommunity(this.get('communityInfo')).then(() => {
        if (this.isDestroyed) { return; }
        Twitch.notify.success(SAVE_SUCCESS);
      }, () => {
        if (this.isDestroyed) { return; }
        Twitch.notify.success(SAVE_ERROR);
      });
    }
  }
});
