import Component from 'ember-component';
import { JTV_USER_PICTURES_404_USER_70X70_URL } from 'web-client/utilities/urls/static-cdn';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';
import run from 'ember-runloop';

export default Component.extend(InteractivityDeferredComponent, {
  user: null,
  isError: false,

  init() {
    this._super(...arguments);
    this.set('avatarUrl', this.get('user.logo') || JTV_USER_PICTURES_404_USER_70X70_URL);
  },

  didInsertElement() {
    this._super();
    run.scheduleOnce('afterRender', this, this.reportInteractive);
  }
});
