import Component from 'ember-component';

export default Component.extend({
  users: null,
  moderators: null,

  willRender() {
    if (this.get('users') && this.get('moderators')) {
      let moderators = this.get('moderators');
      this.get('users').forEach(function(user) {
        let modFound = moderators.filter(function(mod) {
          return mod.name === user.name;
        });
        user.isModerator = modFound.length;
      });
    }
  }
});
