import Component from 'ember-component';
import { KEY_CODES } from 'web-client/utilities/keyboard';

export default Component.extend({
  query: '',

  willDestroyElement() {
    this._clear();
    this._super(...arguments);
  },

  _clear() {
    this.set('query', '');
    this.attrs.search('');
  },

  actions: {
    search(query, event) {
      if (event.keyCode !== KEY_CODES.esc) {
        this.attrs.search(query);
      }
    },

    clear() {
      this._clear();
    }
  }
});
